/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.info;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.client.localisation.LanguageManager;
import com.lycanitesmobs.core.helpers.JSONHelper;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.ElementInfo;
import com.lycanitesmobs.core.info.ElementManager;
import com.lycanitesmobs.core.info.Variant;
import com.lycanitesmobs.core.spawner.condition.SpawnCondition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.model.ModelBase;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Subspecies {
    public Map<Integer, Variant> variants = new HashMap<Integer, Variant>();
    public int index;
    public int priority = 0;
    public String name;
    @SideOnly(value=Side.CLIENT)
    public Class<? extends ModelBase> modelClass;
    public List<ElementInfo> elements = new ArrayList<ElementInfo>();
    public List<SpawnCondition> spawnConditions = new ArrayList<SpawnCondition>();
    public Vec3d mountOffset = new Vec3d(0.0, 1.0, 0.0);

    public static Subspecies createFromJSON(CreatureInfo creatureInfo, JsonObject json) {
        String name = null;
        if (json.has("name")) {
            name = json.get("name").getAsString().toLowerCase();
        }
        Subspecies subspecies = new Subspecies(name, json.get("index").getAsInt());
        if (json.has("variants")) {
            for (Object jsonElement : json.get("variants").getAsJsonArray()) {
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                Variant variant = Variant.createFromJSON(creatureInfo, jsonObject);
                subspecies.variants.put(variant.index, variant);
            }
        }
        if (json.has("modelClass")) {
            try {
                LycanitesMobs.proxy.loadSubspeciesModel(subspecies, json.get("modelClass").getAsString());
            }
            catch (Exception e) {
                LycanitesMobs.logWarning("", "[Creature] Unable to find a valid Java Model Class: " + json.get("modelClass").getAsString() + " for subspecies: " + subspecies.getTitle() + " entity: " + creatureInfo.getTitle());
            }
        }
        if (json.has("priority")) {
            subspecies.priority = json.get("priority").getAsInt();
        }
        List<String> elementNames = new ArrayList<String>();
        if (json.has("element")) {
            elementNames.add(json.get("element").getAsString());
        }
        if (json.has("elements")) {
            elementNames = JSONHelper.getJsonStrings(json.get("elements").getAsJsonArray());
        }
        subspecies.elements.clear();
        for (String elementName : elementNames) {
            ElementInfo element = ElementManager.getInstance().getElement(elementName);
            if (element == null) {
                throw new RuntimeException("[Creature] The element " + elementName + " cannot be found for subspecies: " + subspecies.name);
            }
            subspecies.elements.add(element);
        }
        if (json.has("conditions")) {
            JsonArray jsonArray = json.get("conditions").getAsJsonArray();
            Iterator jsonIterator = jsonArray.iterator();
            while (jsonIterator.hasNext()) {
                JsonObject conditionJson = ((JsonElement)jsonIterator.next()).getAsJsonObject();
                SpawnCondition spawnCondition = SpawnCondition.createFromJSON(conditionJson);
                subspecies.spawnConditions.add(spawnCondition);
            }
        }
        subspecies.mountOffset = JSONHelper.getVec3d(json, "mountOffset", null);
        return subspecies;
    }

    public Subspecies(String name, int index) {
        this.name = name;
        this.index = index;
    }

    public void load(CreatureInfo creatureInfo) {
        if (this.name != null && !creatureInfo.loadedSubspeciesSkins.contains(this.name)) {
            creatureInfo.addSounds("." + this.name);
            creatureInfo.loadedSubspeciesSkins.add(this.name);
        }
    }

    public String getTitle() {
        if (this.name != null) {
            return LanguageManager.translate("subspecies." + this.name + ".name");
        }
        return "";
    }

    public boolean canSpawn(EntityLivingBase entityLiving) {
        if (entityLiving != null) {
            World world = entityLiving.func_130014_f_();
            for (SpawnCondition condition : this.spawnConditions) {
                if (condition.isMet(world, null, entityLiving.func_180425_c())) continue;
                return false;
            }
        }
        return true;
    }

    public Variant getRandomVariant(EntityLivingBase entity, boolean rare) {
        LycanitesMobs.logDebug("Subspecies", "~0===== Variant =====0~");
        LycanitesMobs.logDebug("Subspecies", "Selecting random variant for: " + entity);
        if (rare) {
            LycanitesMobs.logDebug("Subspecies", "The conditions have been set to rare increasing the chances of a variant being picked.");
        }
        if (this.variants.isEmpty()) {
            LycanitesMobs.logDebug("Subspecies", "No variants available, will be base variant.");
            return null;
        }
        LycanitesMobs.logDebug("Subspecies", "Variants Available: " + this.variants.size());
        int baseSpeciesWeightScaled = Variant.BASE_WEIGHT;
        if (rare) {
            baseSpeciesWeightScaled = Math.round((float)baseSpeciesWeightScaled / 4.0f);
        }
        int totalWeight = baseSpeciesWeightScaled;
        for (Variant variant : this.variants.values()) {
            totalWeight += variant.weight;
        }
        LycanitesMobs.logDebug("Subspecies", "Total Weight: " + totalWeight);
        int roll = entity.func_70681_au().nextInt(totalWeight) + 1;
        LycanitesMobs.logDebug("Subspecies", "Rolled: " + roll);
        if (roll <= baseSpeciesWeightScaled) {
            LycanitesMobs.logDebug("Subspecies", "Base variant selected: " + baseSpeciesWeightScaled);
            return null;
        }
        int checkWeight = baseSpeciesWeightScaled;
        for (Variant variant : this.variants.values()) {
            if (roll > (checkWeight += variant.weight)) continue;
            LycanitesMobs.logDebug("Subspecies", "Variant selected: " + variant.toString());
            return variant;
        }
        LycanitesMobs.logWarning("", "The roll was higher than the Total Weight, this shouldn't happen.");
        return null;
    }

    public Variant getVariant(int index) {
        if (!this.variants.containsKey(index)) {
            return null;
        }
        return this.variants.get(index);
    }

    public Variant getChildVariant(EntityLivingBase entity, Variant hostVariant, Variant partnerVariant) {
        int partnerVariantIndex;
        int hostVariantIndex = hostVariant != null ? hostVariant.index : 0;
        int n = partnerVariantIndex = partnerVariant != null ? partnerVariant.index : 0;
        if (hostVariant == partnerVariant) {
            return hostVariant;
        }
        int hostWeight = hostVariant != null ? hostVariant.weight : Variant.BASE_WEIGHT;
        int partnerWeight = partnerVariant != null ? partnerVariant.weight : Variant.BASE_WEIGHT;
        int roll = entity.func_70681_au().nextInt(hostWeight + partnerWeight);
        if (roll > hostWeight) {
            return partnerVariant;
        }
        return hostVariant;
    }

    public String toString() {
        return this.name != null ? this.name : "normal";
    }

    public static int getIndexFromOld(int oldIndex) {
        if (oldIndex > 3) {
            return 1;
        }
        return 0;
    }
}

